/*global define */
/*jslint white: true */

/*
	Scene:

	This object provides the Scene functionality and contains tracks/trackitems/(puppet|audio|scene)
*/

define  ([  "src/build/SceneItem",	"src/utils",    "src/build/treeContainer",	"src/build/DisplayContainerStorage",	"src/build/AudioContainerStorage"],
function(   SceneItem,				utils,			treeContainer,				DisplayContainerStorage,				AudioContainerStorage) {
	'use strict';

	var SceneItem_clone = SceneItem.prototype.clone;

	function Scene(inFrameRate, inPixWidth, inPixHeight, inCenteredOrigin) {
		this.SceneItem("Scene");
		this.DisplayContainerStorage(false, true);
		this.AudioContainerStorage(false, true);
		this.m_children = [];

		// do not modify these private members directly or notifiers won't be called correctly
		this.pSceneData = { 
			frameRate				: inFrameRate, 
			pixWidth				: inPixWidth,
			pixHeight				: inPixHeight,
			centeredOrigin			: inCenteredOrigin || false,
			simulationRateFactor	: 1.0,
			trackItemSource			: null
		};
	}

	utils.mixin(Scene, 
		SceneItem,
		DisplayContainerStorage,
		AudioContainerStorage,
		treeContainer({ childrenLabel   : "m_children" }),
		{
			getFrameRate : function () {
				return this.pSceneData.frameRate;
			},
			getPixelWidth : function () {
				return this.pSceneData.pixWidth;
			},
			getPixelHeight : function () {
				return this.pSceneData.pixHeight;
			},
			isOriginCentered : function () {
				// Only Preview 3 and older projects are not centered.
				return this.pSceneData.centeredOrigin;
			},
			getSimulationRateFactor : function () {
				return this.pSceneData.simulationRateFactor;
			},
			setSimulationRateFactor : function (inSimulationRateFactor) {
				this.pSceneData.simulationRateFactor = inSimulationRateFactor;
			},
			getTrackItemSource : function () {
				return this.pSceneData.trackItemSource;
			},
			setTrackItemSource : function (inTrackItemSource) {
				this.pSceneData.trackItemSource = inTrackItemSource;
			},
			convertToLocalTime : function (inTimeSpan, inParent0) {
				var timeSpan = {t:inTimeSpan.t, dt:inTimeSpan.dt};

				if (!inParent0) {
					// Transform time to frame centers.
					timeSpan.t += inTimeSpan.dt * 0.5;
				}

				return timeSpan;
			},
			clone : function (clone_children, other) {
				var i, ci, 
					result = other;

				if (result) {
					// init
					Scene.call(result);
				} else {
					// alloc and init
					result = new Scene();
				}

				// clone node state
				SceneItem_clone.call(this, clone_children, result);

				utils.clone(true, result.pSceneData, this.pSceneData);
				
				// copy (by default) container children...
				if (clone_children === undefined || clone_children) {
					result.m_children = [];
					for (i = 0; i < this.m_children.length; i += 1) {
						ci = this.m_children[i];
						ci = ci.clone(clone_children);
						result.m_children[i] = ci;
						ci.setParent(result);
					}
				}

				return result;
			}
		}
	);

	return Scene;
});
